/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.config;

import net.dries007.tfc.common.capabilities.size.Size;
import net.minecraftforge.common.ForgeConfigSpec;

public final class ServerConfig {
    public final ContainerConfig strawBasket;
    public final ContainerConfig leatherSack;
    public final ContainerConfig burlapSack;
    public final ContainerConfig oreSack;
    public final ContainerConfig seedPouch;
    public final ContainerConfig framePack;
    public final ContainerConfig lunchBox;
    public final ForgeConfigSpec.BooleanValue doPickup;
    public final ForgeConfigSpec.BooleanValue doVoiding;
    public final ForgeConfigSpec.BooleanValue allPickup;
    public final ForgeConfigSpec.BooleanValue allPickBlock;
    public final ForgeConfigSpec.BooleanValue allAllowOre;
    public final ForgeConfigSpec.BooleanValue allAllowFood;
    public final ForgeConfigSpec.BooleanValue enableContainerInventoryInteraction;
    public final ForgeConfigSpec.DoubleValue traitLunchboxModifier;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Container Item Config");
        this.strawBasket = this.buildContainerConfig(builder, "Straw Basket", true, true, true, 4, 32, Size.VERY_SMALL);
        this.leatherSack = this.buildContainerConfig(builder, "Leather Sack", false, false, true, 4, 64, Size.NORMAL);
        this.burlapSack = this.buildContainerConfig(builder, "Burlap Sack", true, true, false, 8, 48, Size.SMALL);
        this.oreSack = this.buildContainerConfig(builder, "Ore Sack", true, false, true, 1, 512, Size.SMALL);
        this.seedPouch = this.buildContainerConfig(builder, "Seed Pouch", true, false, true, 27, 64, Size.SMALL);
        this.framePack = this.buildContainerConfig(builder, "Frame Pack", false, false, false, 18, 64, Size.LARGE);
        this.lunchBox = this.buildContainerConfig(builder, "Lunch Box", false, false, true, 8, 4, Size.NORMAL);
        builder.pop();
        builder.push("Global config");
        this.doPickup = builder.comment("Global control for automatic pickup, this will not force enable for every type").worldRestart().define("doPickup", true);
        this.doVoiding = builder.comment("A global toggle for item voiding, this will not force enable for every type").define("doVoiding", true);
        this.allPickup = builder.comment(new String[]{"Enable auto pickup for other container like items such as the TFC vessel.", "This may not always work as expected enable at your own discretion"}).define("allPickup", false);
        this.allPickBlock = builder.comment("This allows other containers such as vessels to support the pick block search").define("allPickBlock", false);
        this.allAllowOre = builder.comment("This makes all container types capable of holding ore").define("allAllowOre", false);
        this.allAllowFood = builder.comment("This makes all container types capable of holding food although they won't preserve it!").define("allAllowFood", false);
        this.enableContainerInventoryInteraction = builder.comment("This allows containers to have items inserted and extracted from them via the inventory like vanilla Bundles").define("enableContainerInventoryInteraction", true);
        this.traitLunchboxModifier = builder.comment("The modifer for the 'Lunchbox' food trait. Values less than 1 extend food lifetime, values greater than one decrease it. A value of zero stops decay.").defineInRange("traitLunchboxModifier", 0.6, 0.0, Double.MAX_VALUE);
    }

    private ContainerConfig buildContainerConfig(ForgeConfigSpec.Builder builder, String containerName, boolean doPickup, boolean doVoiding, boolean doInventoryTransfer, int slotCount, int slotCap, Size allowedSize) {
        builder.push(containerName);
        ContainerConfig containerConfig = new ContainerConfig(builder, doPickup, doVoiding, doInventoryTransfer, slotCount, slotCap, allowedSize);
        builder.pop();
        return containerConfig;
    }

    public static final class ContainerConfig {
        public final ForgeConfigSpec.BooleanValue doPickup;
        public final ForgeConfigSpec.BooleanValue doVoiding;
        public final ForgeConfigSpec.BooleanValue doInventoryTransfer;
        public final ForgeConfigSpec.IntValue slotCount;
        public final ForgeConfigSpec.IntValue slotCap;
        public final ForgeConfigSpec.EnumValue<Size> allowedSize;

        public ContainerConfig(ForgeConfigSpec.Builder builder, boolean doPickup, boolean doVoiding, boolean doInventoryTransfer, int slotCount, int slotCap, Size allowedSize) {
            this.doPickup = builder.comment("Determines if this container will automatically pickup items").define("doPickup", doPickup);
            this.doVoiding = builder.comment("Determines if this container can void items on pickup").define("doVoiding", doVoiding);
            this.doInventoryTransfer = builder.comment("Determines if this container can transfer items in an inventory").define("doInventoryTransfer", doInventoryTransfer);
            this.slotCount = builder.comment("This config has a realistic cap of 27 as any higher the slots are added on top of the player slots").defineInRange("slotCount", slotCount, 1, 27);
            this.slotCap = builder.comment("Item stack max for the type of container").defineInRange("slotCap", slotCap, 1, 512);
            this.allowedSize = builder.comment("The maximum item size allowed in the container").defineEnum("allowedSize", (Enum)allowedSize);
        }
    }
}

